<?php
// save this file as gallery.php (or keep your existing filename)
// make sure db_connect.php sets $conn = mysqli_connect(...);
include("db_connect.php");

// sanitize input
$catnames = isset($_GET['catname']) ? mysqli_real_escape_string($conn, $_GET['catname']) : '';

// fetch images into PHP array
$imgs = [];
if ($catnames !== '') {
    $sql = "SELECT * FROM gallery WHERE cat = '$catnames' ORDER BY id DESC";
    $res = mysqli_query($conn, $sql);
    if ($res) {
        while ($row = mysqli_fetch_assoc($res)) {
            $src = '../Assets/shoots/' . $row['images']; // adjust path if needed
            $alt = isset($row['title']) && $row['title'] !== '' ? $row['title'] : $row['images'];
            $imgs[] = ['src' => $src, 'alt' => $alt];
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?php echo $catnames; ?> Gallery</title>
  <style>
    
    .container{max-width:1100px;margin:32px auto;padding:20px}
    h1{font-size:20px;margin:0 0 14px}
    .gallery-card{background:linear-gradient(180deg, rgba(255,255,255,0.02), rgba(255,255,255,0.01));border-radius:16px;padding:16px;box-shadow:0 6px 24px rgba(2,6,23,0.6)}
    .thumb-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(140px,1fr));gap:var(--gap)}
    .thumb{position:relative;overflow:hidden;border-radius:10px;cursor:pointer;background:#071326}
    .thumb img{width:100%;height:100%;object-fit:cover;display:block;transition:transform .35s ease}
    .thumb:hover img{transform:scale(1.06)}
    .thumb .meta{position:absolute;left:8px;bottom:8px;padding:6px 8px;border-radius:8px;background:linear-gradient(90deg,rgba(0,0,0,0.6),rgba(0,0,0,0.2));font-size:12px;color:var(--muted)}
    .lightbox{position:fixed;inset:0;display:none;align-items:center;justify-content:center;padding:28px;background:rgba(2,6,23,0.72);backdrop-filter:blur(6px);z-index:1200}
    .lightbox.open{display:flex}
    .lb-content{max-width:1100px;width:100%;max-height:86vh;display:grid;grid-template-columns:1fr 260px;gap:16px;align-items:start}
    .lb-main{position:relative;background:#071226;border-radius:12px;overflow:hidden;display:flex;align-items:center;justify-content:center}
    .lb-main img{max-width:100%;max-height:82vh;object-fit:contain}
    .lb-side{height:100%;padding:12px;overflow:auto}
    .controls{position:absolute;left:10px;right:10px;top:10px;display:flex;justify-content:space-between;pointer-events:none}
    .controls .btn{pointer-events:auto;background:rgba(0,0,0,0.35);border:none;color:#fff;padding:8px 12px;border-radius:10px;cursor:pointer;font-size:14px}
    .nav{position:absolute;top:50%;transform:translateY(-50%);width:100%;display:flex;justify-content:space-between;padding:0 6px}
    .nav button{background:rgba(0,0,0,0.35);border:none;color:white;padding:10px;border-radius:999px;cursor:pointer}
    .caption{font-size:14px;color:var(--muted);padding:10px 6px;text-align:center}
    .side-thumbs{display:grid;grid-template-columns:1fr;gap:8px}
    .side-thumbs .st{height:80px;border-radius:8px;overflow:hidden;cursor:pointer;opacity:0.76;border:none;background:transparent;padding:0}
    .side-thumbs .st img{width:100%;height:100%;object-fit:cover}
    .side-thumbs .st.active{outline:3px solid rgba(125,211,252,0.14);opacity:1}
    @media (max-width:880px){ .lb-content{grid-template-columns:1fr;} .lb-side{display:flex;gap:8px;overflow-x:auto;padding-bottom:8px} .side-thumbs{grid-auto-flow:column;grid-auto-columns:120px;height:auto} .side-thumbs .st{height:70px;width:120px} }
    .hint{color:var(--muted);font-size:13px;margin-top:8px}
  </style>
</head>
<body>
  <div class="container">
    <h1>Gallery Box — Image Viewer</h1>
    <div class="gallery-card">
      <div class="thumb-grid" id="thumbGrid"></div>
      <p class="hint">Click a thumbnail to open viewer. Use ← → keys or on-screen arrows. Escape to close.</p>
    </div>
  </div>

  <!-- Lightbox -->
  <div class="lightbox" id="lightbox" aria-hidden="true" role="dialog" aria-label="Image viewer">
    <div class="lb-content" role="document">
      <div class="lb-main">
        <div class="controls">
          <div></div>
          <div>
            <button class="btn" id="downloadBtn" title="Download">Download</button>
            <button class="btn" id="closeBtn" title="Close">Close</button>
          </div>
        </div>
        <div class="nav">
          <button id="prevBtn" aria-label="Previous image">◀</button>
          <button id="nextBtn" aria-label="Next image">▶</button>
        </div>
        <img id="lbImage" src="" alt="" />
        <div class="caption" id="lbCaption"></div>
      </div>

      <aside class="lb-side">
        <div class="side-thumbs" id="sideThumbs"></div>
      </aside>
    </div>
  </div>

  <script>
    // IMAGES populated from PHP (safe JSON)
    const IMAGES = <?php echo json_encode($imgs, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_AMP|JSON_HEX_QUOT); ?>;

    const thumbGrid = document.getElementById('thumbGrid');
    const lb = document.getElementById('lightbox');
    const lbImage = document.getElementById('lbImage');
    const lbCaption = document.getElementById('lbCaption');
    const sideThumbs = document.getElementById('sideThumbs');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    const closeBtn = document.getElementById('closeBtn');
    const downloadBtn = document.getElementById('downloadBtn');

    let current = 0;

    function buildThumbs(){
      IMAGES.forEach((img, i)=>{
        // main grid
        const t = document.createElement('button');
        t.className = 'thumb';
        t.setAttribute('aria-label','Open image '+(i+1));
        t.innerHTML = `<img loading="lazy" src="${img.src}" alt="${(img.alt||'').replace(/\"/g,'')}" />
                       <div class="meta">${i+1}/${IMAGES.length}</div>`;
        t.addEventListener('click',()=>openLightbox(i));
        thumbGrid.appendChild(t);

        // side thumbs
        const st = document.createElement('button');
        st.className = 'st';
        st.innerHTML = `<img loading="lazy" src="${img.src}" alt="${(img.alt||'').replace(/\"/g,'')}" />`;
        st.addEventListener('click',()=>showIndex(i));
        sideThumbs.appendChild(st);
      });
    }

    function openLightbox(index){
      current = index; populate(); lb.classList.add('open'); lb.setAttribute('aria-hidden','false');
      document.body.style.overflow = 'hidden';
    }
    function closeLightbox(){
      lb.classList.remove('open'); lb.setAttribute('aria-hidden','true');
      document.body.style.overflow = '';
    }

    function populate(){
      if(!IMAGES.length) return;
      const item = IMAGES[current];
      lbImage.src = item.src;
      lbImage.alt = item.alt || '';
      lbCaption.textContent = item.alt || '';
      Array.from(sideThumbs.children).forEach((n,idx)=>{
        n.classList.toggle('active', idx===current);
      });
      downloadBtn.onclick = ()=>downloadImage(item.src);
    }

    function showIndex(i){ current = i; populate(); }
    function prev(){ current = (current-1+IMAGES.length)%IMAGES.length; populate(); }
    function next(){ current = (current+1)%IMAGES.length; populate(); }

    prevBtn.addEventListener('click',prev);
    nextBtn.addEventListener('click',next);
    closeBtn.addEventListener('click',closeLightbox);

    lb.addEventListener('click',(e)=>{ if(e.target===lb) closeLightbox(); });

    document.addEventListener('keydown', (e)=>{
      if(!lb.classList.contains('open')) return;
      if(e.key==='ArrowLeft') prev();
      if(e.key==='ArrowRight') next();
      if(e.key==='Escape') closeLightbox();
    });

    function downloadImage(url){
      const a = document.createElement('a');
      a.href = url;
      a.download = '';
      document.body.appendChild(a);
      a.click();
      a.remove();
    }

    // init
    buildThumbs();
  </script>
</body>
</html>
